# Amazon GameLift Streams Web SDK and Sample Web Application

## Overview

The Amazon GameLift Streams Web SDK enables front-end applications to connect to Amazon GameLift Streams stream sessions and stream games in a browser. 

This bundle contains the Amazon GameLift Streams Web SDK files and a sample web application called GameLiftStreamsSampleGamePublisher. The sample web application contains a front-end client that has audio and video elements where the game will be streamed to and a lightweight back-end server that starts and stops stream sessions.

## Web SDK

To integrate the Amazon GameLift Streams Web SDK in your existing web application, copy the following files into a directory of your choice in your source code:

* gameliftstreams-x.x.x.d.ts
* gameliftstreams-x.x.x.js
* gameliftstreams-x.x.x.mjs

This supports both ECMAScript modules and CommonJS modules. Use:
```javascript
import * as GameLiftStreamsSdk from 'your-directory/gameliftstreams-x.x.x'
```
or
```javascript
const GameLiftStreamsSdk = require('your-directory/gameliftstreams-x.x.x');
```
replacing the x.x.x with the actual version you have downloaded.

## Sample Web Application

[This guide](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/setting-up-web-sdk.html) provides detailed instructions on setting up resources and getting the sample web application running. Following is a truncated version of the guide.

### Prerequisites

1. Node.js version >= 20
2. [Amazon GameLift Streams supported web browser](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/sdk-browsers-input.html)
3. An Amazon GameLift Streams application in the READY state
4. A stream group in Active status linked to the application, with capacity to host the stream

### Running the web server and application

1. Configure your AWS CLI so it has the credentials for the AWS account you have your streaming resources.
2. Navigate to the GameLiftStreamsSampleGamePublisherService.
    ```bash
    cd GameLiftStreamsSampleGamePublisherService
    ```
3. Install dependencies.
    ```bash
    npm install
    ```
4. Start the server.
    ```bash
    node server.js
    ```
5. Navigate to http://localhost:8000 in your web browser. You should see Stream Demo - Configuration.
6. Input the stream group ID and application ID you prepared earlier into the configuration and choose Click to Start.
7. Enjoy your game!

## References

* [Amazon GameLift Streams backend service and web client](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/sdk.html)
* [About GameLift Streams](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/what-is-service.html)
* [Amazon GameLift Streams stream management guide](https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/manage-streams.html)
* [AWS Game Tech Forum](https://repost.aws/tags/TAOU7EpUOuTQSSWmIHCfb2fQ/amazon-gamelift-streams)